// SCTS_Test.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#include "SCTS.h"

int main(int argc, char* argv[])
{
    int board_index = 0; 
	sctsctl_t board0;
	int status = 0;
	int verbose = 0;
	double current, measu, volt;
	int i;
	char ch;

	if (argc > 1)
	{
		board_index = atoi(argv[1]);
	} 
	if (argc > 2) verbose = 1;

	board0 = SCTSCTL_OPEN(0);
	if (board0->hDevice == PCITG_NULL)
	{
		printf("No PCI SCTS Card Found On System !\n\n");
		printf("Please Contact Soliton Tech. Co, LTD.\n");
		printf("http://www.soliton.com.tw\n\n");						
		return 1;
	} 
	else
	{
		printf("Board[%d] found, Device Handle = 0x%.8X\n", board_index, board0->hDevice);
	}

	SCTSCTL_CARDSERVICE_INIT(board0);	
	Sleep(100);
	//status = SCTSCTL_GPIORESET(board0, 0);
	//status = SCTSCTL_GPIORESET(board0, 1);
	
	do
	{
		printf("[Press Command]\n");
		printf("1 : Power on\n");
		printf("2 : Power off\n");
		printf("3 : LED Go\n");
		printf("4 : LED NG\n");
		printf("5 : LED Off\n");
		printf("6 : Read VI\n");
		printf("7 : GPIO-0 On\n");
		printf("8 : GPIO-0 Off\n");
		printf("a : Beep 1\n");
		printf("b : Beep 2\n");
		printf("q : Quit\n\n");
		status = 0;
		ch = getch();
		switch(ch)
		{
		case '1' :
			status=0;
			status = SCTSCTL_PON(board0);
			printf("[Power on] Status = %d\n\n", status);
			break;
		case '2':
			status = SCTSCTL_POFF(board0);
			printf("[Power off] Status = %d\n\n", status);
			break;
		case '3':
			status = SCTSCTL_LEDGO(board0);
			break;
		case '4':
			status = SCTSCTL_LEDNG(board0);
			break;
		case '5':
			status = SCTSCTL_LEDOFF(board0);
			break;
		case '6':
			SCTSCTL_MEAS_VOLTAGE(board0, &volt);
				measu=0;
				for(i=0; i<10; i++)
				{				
					SCTSCTL_MEAS_CURRENT(board0, &current);
					Sleep(100);
					if(current > 0)
					{	
						measu+= current;
					}
				}		
			printf("V=[%f]V  I=[%f]mA\n", volt, current*1e3);
			break;
		case '7':
            // Pin DUTCTL1 Output (H) 
			//[m_pinno]  0:Pin DUTCTL0   1:Pin DUTCTL1
			status = SCTSCTL_GPIOSET(board0, 0);             
			break;
		case '8':
			// Pin DUTCTL1 Output (L) 
			//[m_pinno]  0:Pin DUTCTL0   1:Pin DUTCTL1
			status = SCTSCTL_GPIORESET(board0, 0);
			break;
		case 'a':
			status = SCTSCTL_BEEP(board0, 0, 1000);
			break;
		case 'b':
			status = SCTSCTL_BEEP(board0, 3, 500);
			break;
		default:
			break;
		}
		//printf("Status = %d\n", status);
	}while(ch != 'q');

	SCTSCTL_CARDSERVICE_EXIT(board0);	// Normal
	SCTSCTL_CLOSE(board0);
	return 0;
}

